/***************************************************************************
 *   Copyright (C) 2005 by Sergio Pérez                                    *
 *   qflash@etynos.org                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#include "items.h"
#include <qpainter.h>
#include <qpointarray.h>
#include <qbuffer.h>
#include <qcstring.h>

#include <iostream>
using namespace std;


// NODEITEM ///////////////////////////////////////////

NodeItem::NodeItem( double x, double y, QCanvas *canvas) :
 QCanvasEllipse( 6, 6, canvas )
{
  setX(x);
  setY(y);
  setZ( 100000 );
  setBrush( Qt::red );
  show();
  canvas->update();
  nodeRtti = 0;
  
}

void NodeItem::moveBy(double dx, double dy)
{
    QCanvasEllipse::moveBy( dx, dy );
    show();
    canvas()->update();
} 


// POLYGON ///////////////////////////////////////////

void Polygon::showNodes()
{
  NodeItem* nodes;
  
  for (int i=0; i<(int)areaPoints().count();i++)
  {
    nodes = new NodeItem(areaPoints().at(i).x(), areaPoints().at(i).y(), canvas());
    nodes->nodeRtti = i;
  }

  return;
}


Polygon::Polygon(QCanvas *canvas): QCanvasPolygon(canvas )
{
  show();
  canvas->update();
  effect = 0;
  grouped = 0;
  button = 0;
  name = "";
}

Polygon::Polygon( Polygon* tempItem, QCanvas *canvas, int dx, int dy): QCanvasPolygon( canvas )
{
  setPen( tempItem->pen );
  setBrush( tempItem->brush() );
  polyline = tempItem->polyline.copy();

  setZ( tempItem->z() );
  setX( tempItem->x() );
  setY( tempItem->y() );
  setPoints( tempItem->polyline );
  moveBy(dx, dy);
  effect = 0;
  grouped = 0;
  button = 0;
  show();
  canvas->update();
  name = "";
}

void Polygon::moveBy(double dx, double dy)
{
 QCanvasPolygon::moveBy(dx,dy);
 canvas()->setAllChanged ();
 canvas()->update();
}

void Polygon::drawShape ( QPainter & p )
{
  QCanvasPolygon::drawShape(p);
  p.setPen(pen);
  p.drawConvexPolygon(areaPoints());
}

void Polygon::setPen ( QPen tmp)
{
  pen = tmp;
  canvas ()->setAllChanged ();
} 


QString Polygon::xml()
{
  QString s;
  QPointArray pa = areaPoints();
  s = "<item class=\"Polygon\" name=\""+name+"\" x=\"" +QString::number(0)+ "\" y=\"" +QString::number(0)+  "\" ";
  for (int i = 0; i<(int)pa.count() ; i++)
  {
    s += "x" +QString::number( i )+ "=\"" + QString::number( pa.at(i).x() ) + "\" y" +QString::number( i )+ "=\"" + QString::number( pa.at(i).y() )+ "\" ";
  }
  s += "z=\"" + QString::number( z() ) + "\" border=\"" + pen.color().name() +  "\" color=\"" + brush().color().name() + "\" layer=\""+ QString::number((int) (z()/3000))+"\" />";
  return s;
}





// RECTITEM ///////////////////////////////////////////

void RectItem::showNodes()
{
  NodeItem* nodes;
  nodes =  new NodeItem(x(), y(), canvas());
  nodes->nodeRtti = 0;
  nodes =  new NodeItem(x()+width(), y(), canvas());
  nodes->nodeRtti = 1;
  nodes =  new NodeItem(x()+width(), y()+height(), canvas());
  nodes->nodeRtti = 2;
  nodes =  new NodeItem(x(), y()+height(), canvas());
  nodes->nodeRtti = 3;
  return;
}

RectItem::RectItem( int x, int y, int w, int h, QCanvas *canvas): QCanvasRectangle( x, y, w, h, canvas )
{
  show();
  effect = 0;
  grouped = 0;
  button = 0;
  name = "";
  canvas->update();
}


RectItem::RectItem( RectItem* tempItem, QCanvas *canvas): QCanvasRectangle( canvas )
{
  cout << 1.1 << endl;
  setPen( tempItem->pen() );
  setBrush( tempItem->brush() );
  setX( tempItem->x() );
  setY( tempItem->y() );
  setZ( tempItem->z() );
  cout << 1.2 << endl;
  setSize( tempItem->width(),  tempItem->height() );
  effect = 0;
  grouped = 0;
  button = 0;
  name = "";
  show();
  canvas->update();
}

QString RectItem::xml()
{
  QString s;
  s = "<item class=\"RectItem\" name=\""+name+"\" x=\"" + QString::number( x() ) + "\" y=\"" + QString::number( y() ) + "\" width=\"" + QString::number( width() ) +  "\" height=\"" + QString::number( height() ) + "\" z=\"" + QString::number( z() ) + "\"  border=\"" + pen().color().name() +  "\" color=\"" + brush().color().name() + "\" layer=\""+ QString::number( (int) (z()/3000))+"\" />";
  return s;
}


// OVALITEM ///////////////////////////////////////////

OvalItem::OvalItem(int w, int h, QCanvas* canvas): QCanvasEllipse( w, h, canvas )
{
  effect = 0;
  grouped = 0;
  button = 0;
  name = "";
  show();
  canvas->update();
}

OvalItem::OvalItem( OvalItem* tempItem, QCanvas *canvas): QCanvasEllipse( canvas )
{
  setPen( tempItem->pen );
  setBrush( tempItem->brush() );
  setX( tempItem->x() );
  setY( tempItem->y() );
  setZ( tempItem->z() );
  setSize( tempItem->width(),  tempItem->height() );
  effect = 0;
  grouped = 0;
  button = 0;
  name = "";
  show();
  canvas->update();
}

void OvalItem::drawShape ( QPainter & p )
{
  p.setPen(pen);
  p.drawEllipse(int(x()-width()/2.0+0.5), int(y()-height()/2.0+0.5), width(), height());
}

void OvalItem::setPen ( QPen tmp)
{
  pen = tmp;
  canvas ()->setAllChanged ();
} 

void OvalItem::showNodes()
{
  NodeItem* nodes;
  nodes =  new NodeItem(x(), y()-height()/2, canvas());
  nodes->nodeRtti = 0;
  nodes =  new NodeItem(x()+width()/2, y(), canvas());
  nodes->nodeRtti = 1;
  nodes =  new NodeItem(x(), y()+height()/2, canvas());
  nodes->nodeRtti = 2;
  nodes =  new NodeItem(x()-width()/2, y(), canvas());
  nodes->nodeRtti = 3;
  return ;
}

QString OvalItem::xml()
{
  QString s;
  s = "<item class=\"OvalItem\" name=\""+name+"\" x=\"" + QString::number( x() ) + "\" y=\"" + QString::number( y() ) + "\" width=\"" + QString::number( width() ) +  "\" height=\"" + QString::number( height() ) + "\" z=\"" + QString::number( z() ) + "\"  border=\"" + pen.color().name() +  "\" color=\"" + brush().color().name() + "\" layer=\""+ QString::number((int) (z()/3000) )+"\" />";
  return s;
}

// LINEITEM ///////////////////////////////////////////


LineItem::LineItem( QCanvas * canvas): QCanvasLine( canvas )
{
  effect = 0;
  grouped = 0;
  button = 0;
  name = "";
  show();
  canvas->update();
}

LineItem::LineItem(LineItem* tempItem, QCanvas * canvas): QCanvasLine( canvas )
{
  setPoints( tempItem->startPoint().x(), tempItem->startPoint().y(), tempItem->endPoint().x(), tempItem->endPoint().y() );
  setPen( tempItem->pen() );
  setX( tempItem->x() );
  setY( tempItem->y() );
  setZ( tempItem->z() );
  effect = 0;
  grouped = 0;
  button = 0;
  name = "";
  show();
  canvas->update();
}

void LineItem::showNodes()
{
  NodeItem* nodes;
  nodes =  new NodeItem(x()+startPoint().x(), y()+startPoint().y(), canvas());
  nodes->nodeRtti = 0;
  nodes =  new NodeItem(x()+endPoint().x(), y()+endPoint().y(), canvas());
  nodes->nodeRtti = 1;
  return;
}

QString LineItem::xml()
{
  QString s;
  s = "<item class=\"LineItem\" name=\""+name+"\" x=\"" + QString::number( startPoint().x() ) + "\" y=\"" + QString::number( startPoint().y() ) + "\" x2=\"" + QString::number( endPoint().x() ) + "\" y2=\"" + QString::number( endPoint().y() ) + "\" z=\"" + QString::number( z() ) + "\" border=\"" + pen().color().name() +  "\" layer=\""+ QString::number((int) (z()/3000) )+"\" />";
  return s;
}










// BRUSHITEM ///////////////////////////////////////////


BrushItem::BrushItem(QCanvas * canvas):QCanvasPolygonalItem(canvas)
{
  view = 1;
  effect = 0;
  grouped = 0;
  button = 0;
  name = "";
}

BrushItem::BrushItem( BrushItem* tempItem, QCanvas *canvas, int dx, int dy): QCanvasPolygonalItem( canvas )
{
  effect = 0;
  view = 1;
  grouped = 0;
  button = 0;
  name = "";
  setPen( tempItem->pen() );
  setBrush( tempItem->brush() );
  setZ( tempItem->z() );
  width = tempItem->width;
  polyline = tempItem->polyline.copy();
  polyline.translate(dx,dy);
  show();
  
}


void BrushItem::showNodes()
{
   if (!view) return;

   NodeItem* nodes;
   for (int i=0; i<(int)polyline.count(); i++)
   {
     nodes = new NodeItem(polyline.at(i).x(), polyline.at(i).y(), canvas());
     nodes->nodeRtti = i;
   }
   return;
}


void BrushItem::drawShape ( QPainter & paint )
{
  if (view)
  {
    QPen pen ;
    pen.setWidth(width);
    paint.setPen(pen);
    paint.drawPolyline(polyline);
  }
 
}

QPointArray BrushItem::areaPoints() const
{
  QPointArray tempa = QPointArray( polyline.count()*2);
  for (int i=0; i<(int)polyline.count();i++)
  {
    tempa.at(i) = QPoint(polyline[i].x() + width , polyline[i].y() - width );
    tempa.at(i) = QPoint(polyline[i].x() - width , polyline[i].y() - width );
  }

  int a = 1;

  for (int i=tempa.size()/2; i<(int)tempa.size();i++)
  {
    tempa.at(i) = QPoint(polyline[ polyline.count() - a].x() - width , polyline[ polyline.count() - a ].y() + width);
    tempa.at(i) = QPoint(polyline[ polyline.count() - a].x() + width , polyline[ polyline.count() - a ].y() + width);
    a++;
  }

return tempa;
}


void BrushItem::moveBy(double dx, double dy)
{
  QCanvasItem::moveBy(dx,dy);
  polyline.translate((int)dx,(int)dy);
}





QString BrushItem::xml()
{
  QString s;
  QPointArray pa = polyline;
  s = "<item class=\"BrushItem\" name=\""+name+"\" ";
  for (int i = 0; i< (int)pa.count() ; i++)
  {
    s += "x" +QString::number( i )+ "=\"" + QString::number( pa.at(i).x() ) + "\" y" +QString::number( i )+ "=\"" + QString::number( pa.at(i).y() )+ "\" ";
  }
  s += "z=\"" + QString::number( z() ) + "\" border=\"" + pen().color().name() + "\" width=\"" + QString::number( width ) + "\" layer=\""+ QString::number( (int) (z()/3000))+"\" />";
  return s;
}



// IMAGEITEM ///////////////////////////////////////////

ImageItem::ImageItem( QImage img, QCanvas *canvas )
    : QCanvasRectangle( canvas ), image(img)
{
  effect = 0;
  setSize( image.width(), image.height() );
  pixmap.convertFromImage(image, OrderedAlphaDither);
  sw = 1;
  sh = 1;
  mirrorH = 0;
  mirrorV = 0;
  grouped = 0;
  button = 0;
  name = "";
}

ImageItem::ImageItem( ImageItem* tempItem, QCanvas *canvas )
    : QCanvasRectangle( canvas ), image(tempItem->image)
{
  effect = 0;
  grouped = 0;
  button = 0;
  name = "";
  pixmap.convertFromImage(image, OrderedAlphaDither);
  fileName = tempItem->fileName;
  sw = tempItem->sw;
  sh = tempItem->sh;
  mirrorH = tempItem->mirrorH;
  mirrorV = tempItem->mirrorV;
  setX( tempItem->x() );
  setY( tempItem->y() );
  setZ( tempItem->z() );
  setSize( tempItem->width(),  tempItem->height() );
  show();
}

void ImageItem::showNodes()
{
   NodeItem* nodes;
   nodes =  new NodeItem(x(), y(), canvas());
   nodes->nodeRtti = 0;
   nodes =  new NodeItem(x()+width(), y(), canvas());
   nodes->nodeRtti = 1;
   nodes =  new NodeItem(x()+width(), y()+height(), canvas());
   nodes->nodeRtti = 2;
   nodes =  new NodeItem(x(), y()+height(), canvas());
   nodes->nodeRtti = 3;
   return;
}

void ImageItem::drawShape( QPainter &p )
{
    QWMatrix m;
    m.scale( sw, sh );
    pixmap.convertFromImage(image.xForm(m), OrderedAlphaDither);
    
    int a = (int) x();
    int b = (int) y();
    if (mirrorH) a = (int) (x() + width());
    if (mirrorV) b = (int) (y() + height());
    p.drawPixmap( a, b, pixmap );
    
}

bool ImageItem::hit( const QPoint &p ) const
{
    int ix = p.x()-int(x());
    int iy = p.y()-int(y());
    if ( !image.valid( ix , iy ) )
      return FALSE;
    QRgb pixel = image.pixel( ix, iy );
    return qAlpha( pixel ) != 0;
}

QString ImageItem::xml()
{
   QString s;
   s = "<item class=\"ImageItem\" name=\""+name+"\" url=\""+ fileName +"\" z=\"" + QString::number( z() ) + "\" x=\"" + QString::number( x() ) + "\" y=\"" + QString::number( y() ) +"\" width=\"" +QString::number(width())+ "\" height=\"" +QString::number(height())+ "\" mirrorH=\""+ QString::number(mirrorH)+"\" mirrorV=\""+ QString::number(mirrorV)+"\"  sw=\""+ QString::number(sw)+"\" sh=\""+ QString::number(sh)+"\" layer=\""+ QString::number((int) (z()/3000))+"\" />";
   return s;
}

// CANVASITEM ///////////////////////////////////////////


CanvasItem::CanvasItem( int x, int y, int w, int h, QCanvas *canvas): QCanvasRectangle( x, y, w, h, canvas )
{
  adjust = new adjustItem(x+w, y+h, canvas);
  show();
  canvas->update();
}

//  ADJUSTITEM ///////////////////////////////////////


adjustItem::adjustItem( int x, int y, QCanvas *canvas): QCanvasRectangle( x+4, y+4, 7, 7, canvas )
{
  setBrush( black );
  setPen ( black );
  show();
  canvas->update();
}


//   TEXTHIGHLIGHTITEM  //////////////////////

textHighlightItem::textHighlightItem(QRect& rect, QCanvas* canvas): QCanvasRectangle(rect, canvas)
{  

  setBrush( QColor( 255,235,85));
  setPen( QColor( 255,235,85));
  show();

}

// ADJUSTTEXT  /////////////////////

adjustText::adjustText(QString text, QCanvas* canvas):QCanvasText(text, canvas)
{
}

//  GROUPLINEITEM  ///////////////

groupLineItem::groupLineItem ( QCanvas* canvas): QCanvasLine(canvas)
{
  setZ(2000);
}


buttonCanvasLineItem::buttonCanvasLineItem ( QCanvas* canvas): QCanvasLine(canvas)
{
  setZ(4);
  setPen(Qt::yellow);

}


