/***************************************************************************
 *   Copyright (C) 2005 by Sergio Pérez                                    *
 *   qflash@etynos.org                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef ITEMGR_H
#define ITEMGR_H

#include <qcanvas.h>
#include <items.h>
class groupLineItem;
class ButtonItem;
class Editor;

class itemGroup
{
public:
    itemGroup(QCanvas*);
    QCanvasItemList items;
    QCanvas* canvas;
    
    int startx;
    int starty;
    int endx;
    int endy;
    
    groupLineItem* line1;
    groupLineItem* line2;
    groupLineItem* line3;
    groupLineItem* line4;
    void moveBy(double, double);

    bool isButton;
    ButtonItem* buttonGroup;
    QString xml(Editor*);
    QStringList imagelist;

    
public slots:
    void showNodes();
    void hideNodes();
    void updatePoints();
};

#endif

