/***************************************************************************
 *   Copyright (C) 2005 by Sergio Pérez                                    *
 *   qflash@etynos.org                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef EDITOR_H
#define EDITOR_H

#include "items.h"

#include <qcanvas.h>
#include <qcursor.h>
#include <qcolor.h>
#include <qmainwindow.h>
#include <qcanvas.h>
#include <qptrlist.h>
#include <asDialog.h>

#include "textbox.h"
#include "undo.h"
// class animationASActions;

class Editor: public QCanvasView
{
Q_OBJECT


public:

  Editor(QCanvas* c, QWidget* parent=0);

  int zoom;
  int cenx,ceny,movx,movy;
  RectItem* rect;
  OvalItem* oval;
  LineItem* line;
  Polygon * poly;
  int pol;
  QPtrList<QPoint> points;
  QPointArray pa;
  BrushItem* brush;
  Regular* regu;
  TextBox* tbox; 
  Regular* reguEnd;
  CanvasTextItem* text;
  int tmp1, tmp2; // used in nodechanged()
  int draggingAdjustItem;

  QPoint* pt;
  QPoint eo; //preview --contentstoviewport--
  QCursor inkbottleCursor;
  QCursor paintbucketCursor;
  QCursor eraserCursor;
  QCanvasItem* moving;
  QCanvasItem* choosen;
  QCanvasItem* buffered;
  textHighlightItem* textHighlight;
  ButtonItem* button;
  bool cutt; //if 0 copy if 1 cut, for slotPasteFrame() 
  bool rightButton;
  QCanvasLine* line1;
  QCanvasLine* line2;
  QCanvasLine* line3;
  QCanvasLine* line4;

  QCanvasItemList multiSelect;
  actionList* undoActionList;
  int origX;
  int origY;

  QCanvas* backForButton;
  bool editingButton;
  animationASActions animAction;
  QStringList names;
  void updateNames();


public slots:

  void updateAll();
  void hideNodes();
  void moveNodes(double, double);
  void nodes();
  void nodeChanged(double, double);
  NodeItem* lookNode(int);
  void itemDown();
  void itemUp();
  void cut();
  void copy();
  void paste(bool window = 0);
  void menuDelete();
  void deleteShape( QCanvasItem*);
  QCanvasItem* copyItem(QCanvasItem*);
  int getZ();
  void addAS(int frame = -1);
  int addEffect();
  void prepareEffect();
  bool isValid(QCanvasItem*);
  itemGroup* group(ButtonItem* = NULL);
  void ungroup();
  int moveGroup(QCanvasItem*);
  QCanvasItemList filterSelection(QCanvasItemList);
  itemGroup* getGroup(QCanvasItem* );
  ButtonItem* getButton(QCanvasItem* );
  void moveAllButtonCanvas( ButtonItem* );
  TextBox* getTextBox(QCanvasItem*);
  void nameChange();
  QString getName(QCanvasItem* = NULL);
  void setName( const QString&, QCanvasItem* = NULL);
  QCanvasItemList sortByZ( QCanvasItemList );

private:

  void contentsMouseMoveEvent(QMouseEvent*);
  void contentsMouseReleaseEvent(QMouseEvent*);
  void contentsMousePressEvent(QMouseEvent*);
  void contentsMouseDoubleClickEvent(QMouseEvent*);

  void enterEvent(QEvent*);
  void leaveEvent(QEvent*);


};

#endif
