/***************************************************************************
 *   Copyright (C) 2005 by Sergio Pérez                                    *
 *   qflash@etynos.org                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "colors.h"

#include <qvariant.h>
#include <qbuttongroup.h>
#include <qradiobutton.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <qlayout.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <qimage.h>
#include <qpixmap.h>
#include <qcolordialog.h>
#include <qfiledialog.h>

#include <images/select.xpm>



Colors::Colors( QWidget* parent, const char* name, WFlags fl )
    : QWidget( parent, name, fl )
{
    if ( !name ) setName( "Colors" );
    
    l = QColor(Qt::darkBlue);
    r = QColor(Qt::yellow);
    i = QPixmap(select_xpm);
    
   //orange 255,85,00
    
    pushButton1 = new QPushButton( this, "pushButton1" );
    pushButton1->setGeometry( QRect( 20, 5, 40, 40 ) );
    pushButton1->setPaletteBackgroundColor( l );

    pushButton2 = new QPushButton( this, "pushButton2" );
    pushButton2->setGeometry( QRect( 60, 35, 40, 40 ) );
    pushButton2->setPaletteBackgroundColor( r );

    
    //all this stuff is ready to include Gradient support and to fill shapes with textures
    
    
    /*  
    buttonGroup1 = new QButtonGroup( this, "buttonGroup1" );
    buttonGroup1->setGeometry( QRect( 5, 85, 110, 90 ) );
    buttonGroup1->setFrameShape(QFrame::NoFrame);
    
    buttonGroup2 = new QButtonGroup( this, "buttonGroup2" );
    buttonGroup2->setGeometry( QRect( 5, 235, 110, 80 ) );
    buttonGroup2->setFrameShape(QFrame::NoFrame);
    //buttonGroup2->hide();
    
    radioButton1 = new QRadioButton( buttonGroup1, "radioButton1" );
    radioButton1->setGeometry( QRect( 10, 20, 90, 16 ) );
    radioButton1->setChecked( true );
   
    radioButton2 = new QRadioButton( buttonGroup1, "radioButton2" );
    radioButton2->setGeometry( QRect( 10, 40, 70, 16 ) );

    radioButton3 = new QRadioButton( buttonGroup1, "radioButton3" );
    radioButton3->setGeometry( QRect( 10, 60, 70, 16 ) );
   
    Label1 = new QLabel( this, "Label1" );
    Label1->setGeometry( QRect( 10, 175, 100, 15 ) );
    Label1->setScaledContents( TRUE );
    
        
    radioButton4 = new QRadioButton(this, "radioButton4" );
    radioButton4->setGeometry( QRect( 10, 200, 16, 16 ) );
    radioButton4->setChecked( false );
    
    
    pushButton3 = new QPushButton( this, "pushButton3" );
    pushButton3->setGeometry( QRect( 30, 200, 70, 20 ) );
    pushButton3->setEnabled(false);
    */

    
    languageChange();

    
//QObject::connect( radioButton4, SIGNAL(toggled(bool)), pushButton3,SLOT(setEnabled(bool)));
QObject::connect( pushButton1, SIGNAL(pressed()),this,SLOT(elige_l()));
QObject::connect( pushButton2, SIGNAL(pressed()), this,SLOT(elige_r()));
//QObject::connect( pushButton3, SIGNAL(pressed()), this,SLOT(elige_i()));
}

Colors::~Colors()
{
}

void Colors::languageChange()
{
    setCaption( tr( "Colors" ) );
    
    /*buttonGroup1->setTitle( tr( "Gradient" ) );
    radioButton1->setText( tr( "None" ) );
    radioButton2->setText( tr( "Linear" ) );
    radioButton3->setText( tr( "Round" ) );
    buttonGroup2->setTitle( tr( "Preview" ) );
    Label1->setText(tr("Image"));
    pushButton3->setText(tr("File..."));
    */
}


void Colors::elige_l()
{
  QColor end = QColorDialog::getColor ( l );
  if (end != QColor("0"))
  {
    pushButton1->setPaletteBackgroundColor( end );
    l = end;
    emit colorChanged();
  }
}

void Colors::elige_r()
{
  QColor end = QColorDialog::getColor ( r );
  if (end != QColor("0"))
  {
    pushButton2->setPaletteBackgroundColor( end );
    r = end;
    emit colorChanged();
  }
}

void Colors::elige_i()
{
QFileDialog a;
i = QPixmap(a.getOpenFileName("/root","Images (*.png *.xpm *.jpg *.bmp *.gif)", this,"open file dialog","Choose a file" ));
}
