/***************************************************************************
 *   Copyright (C) 2005 by Sergio Pérez                                    *
 *   qflash@etynos.org                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#include "canvas.h"
#include <items.h>
#include <qobject.h>

#include "editor.h"

#include <iostream>
using namespace std;

Canvas::Canvas(int x, int y, int sepx, int sepy ): QCanvas(x + sepx,y + sepy)
{
  
  back = new CanvasItem(sepx/2,sepy/2,x,y,this);
  this->setBackgroundColor(Qt::gray);
  imagelist = "";
  sx = sepx;
  sy = sepy;
  z = 10;
  adjustSizeText = new adjustText( "" , this );

}


Canvas::Canvas(Canvas* tmpCanvas): QCanvas(tmpCanvas->width(), tmpCanvas->height())
{

  this->setBackgroundColor(Qt::gray); 
  back = new CanvasItem(sx/2,sy/2,tmpCanvas->width() -sx,tmpCanvas->height() -sy ,this);
  imagelist = "";
  back->setZ(-2);
  
}



QString Canvas::xml(int templayer, Editor* ed)
{

  imagelist = "";
  QString s;
  QCanvasItemList all = allItems();
  QCanvasItemList l;
  QCanvasItem* moving;


  
  for (QCanvasItemList::Iterator it = all.begin(); it != all.end(); it++)  //it selects the items in the layer templayer
  {
         moving = (QCanvasItem*) *it;

      if ( ((int) (moving->z()/3000) == templayer)  )
      {
         l.append(*it);
      }
  }
  l= ed->filterSelection(l);
  l= ed->sortByZ( l );


  if (l.count() == 0) 
    return "";

  
    for (QCanvasItemList::Iterator it = l.begin(); it != l.end(); it++)
    {
       moving = (QCanvasItem*) *it;

        if (ed->getGroup(moving) != NULL || ed->getTextBox(moving) != NULL)
        {

           if (ed->getTextBox(moving) != NULL)
           {
             TextBox* tempT = ed->getTextBox(moving);
             s += "\t\t" +tempT->xml()+ "\n";
           }

           if (ed->getGroup(moving) != NULL)
           {

                if(ed->getButton(moving) != NULL)
                {
                   ButtonItem* tempB = ed->getButton(moving);
                   ed->moveAllButtonCanvas( tempB );
                   s += "\t\t" +tempB->xml(ed)+ "\n";
                   for (int j=0; j<(int)tempB->imagelist.count() ; j++ )
                   {
                       QStringList::Iterator it = tempB->imagelist.at(j);
                       QString  first = (QString) *it;
                       imagelist.append(first);
                   }
                }
                else
                {

                   itemGroup* tempG = ed->getGroup(moving);
                   s += "\t\t" +tempG->xml(ed)+ "\n";
                   for (int j=0; j<(int) tempG->imagelist.count() ; j++ )
                   {
                       QStringList::Iterator it = tempG->imagelist.at(j);
                       QString  first = (QString) *it;
                       imagelist.append(first);
                   }
                }

             }


          }
          else
          switch (moving->rtti())
          {

            case QCanvasItem::Rtti_Rectangle:
            {
               RectItem* rec;
               rec = (RectItem*) moving;
               s += "\t\t" +rec->xml()+ "\n";
               break;
            }
            case QCanvasItem::Rtti_Ellipse:
            {
               OvalItem* eli;
               eli = (OvalItem*) moving;
               s += "\t\t" +eli->xml()+ "\n";
               break;
            }
            case QCanvasItem::Rtti_Line:
            {
               LineItem* lin;
               lin = (LineItem*) moving;
               s += "\t\t" +lin->xml()+ "\n";
               break;
            }
            case QCanvasItem::Rtti_Polygon:
            {
               Polygon* pol;
               pol = (Polygon*) moving;
               s += "\t\t" +pol->xml()+ "\n";
               break;
            }
            case QCanvasItem::Rtti_Text:
            {
               CanvasTextItem* text;
               text = (CanvasTextItem*) moving;
               s += "\t\t" +text->xml()+ "\n";
               break;
            }
            case 86:
            {
               ImageItem* ima;
               ima = (ImageItem*) moving;
               s += "\t\t" +ima->xml()+ "\n";
               imagelist.append(ima->fileName);
               break;
            }
            case 87:
            {
//                PencilItem* pen;
//                pen = (PencilItem*) moving;
//                if (pen->view)
//                     s += "\t\t" +pen->xml()+ "\n";
                break;
            }
            case 88:
            {
               BrushItem* bru;
               bru = (BrushItem*) moving;
               if (bru->view ) //Qflash crashed when a brushitem or pencilitem was deleted so they are only hidden. View property states if it is shown or not
                   s += "\t\t" +bru->xml()+ "\n";
               break;
            }
            case 89:
            {
               Regular* regu;
               regu = (Regular*) moving;
               if (regu->view) 
                  s += "\t\t" +regu->xml()+ "\n";
               break;
            }

       } // end of switch

    }


  return s;

} // end of for




QString Canvas::imageList()
{
return imagelist.join(" ");
}

