/***************************************************************************
 *   Copyright (C) 2005 by Sergio Pérez                                    *
 *   qflash@etynos.org                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef BUT_H
#define BUT_H

#include <qcanvas.h>
#include <qstring.h>

class Editor;
class buttonCanvas;
class Canvas;
class Window;

class buttonASActions
{
 public:
  buttonASActions();
  buttonASActions copy();
  QString actionOver;
  QString actionOut;
  QString actionUp;
  QString actionUpOutside;
  QString actionDown;
  QString actionDragOut;
  QString actionDragOver;

};

class ButtonItem
{
 
public:

  ButtonItem();
  ButtonItem( ButtonItem* , Window*);
  buttonCanvas* canvasUp;
  buttonCanvas* canvasOver;
  buttonCanvas* canvasDown;

  Canvas* canvasButton;
  // ActionScript actions 
  QString name;
  buttonASActions actions;
  double dx;
  double dy;
  QString xml(Editor*);
  QStringList imagelist;
  QString imageList();//returns imageList in an only string

};

class buttonCanvas: public QCanvas
{
 public:
 
 buttonCanvas();

};



#endif

