/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.ir.ts;

import com.googlecode.dex2jar.ir.IrMethod;
import com.googlecode.dex2jar.ir.StmtTraveler;
import com.googlecode.dex2jar.ir.expr.Exprs;
import com.googlecode.dex2jar.ir.expr.InvokeExpr;
import com.googlecode.dex2jar.ir.expr.Local;
import com.googlecode.dex2jar.ir.expr.NewExpr;
import com.googlecode.dex2jar.ir.expr.Value;
import com.googlecode.dex2jar.ir.stmt.AssignStmt;
import com.googlecode.dex2jar.ir.stmt.Stmt;
import com.googlecode.dex2jar.ir.stmt.Stmts;
import com.googlecode.dex2jar.ir.ts.Cfg;
import com.googlecode.dex2jar.ir.ts.Transformer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public class NewTransformer
implements Transformer {
    @Override
    public void transform(IrMethod method) {
        final HashMap<Local, NewExpr> nAssign = new HashMap<Local, NewExpr>();
        final HashMap<Local, AssignStmt> init = new HashMap<Local, AssignStmt>();
        for (Stmt p : method.stmts) {
            if (p.st != Stmt.ST.ASSIGN || p.getOp1().vt != Value.VT.LOCAL || p.getOp2().vt != Value.VT.NEW) continue;
            Local local = (Local)p.getOp1();
            nAssign.put(local, (NewExpr)p.getOp2());
            init.put(local, (AssignStmt)p);
        }
        if (nAssign.size() == 0) {
            return;
        }
        int[] reads = Cfg.countLocalReads(method);
        final HashSet<Local> oneOrLess = new HashSet<Local>();
        final boolean[] changed = new boolean[]{true};
        while (changed[0]) {
            changed[0] = false;
            for (Local local : nAssign.keySet()) {
                if (reads[local._ls_index] >= 2) continue;
                oneOrLess.add(local);
                method.stmts.remove((Stmt)init.remove(local));
                method.locals.remove(local);
            }
            if (oneOrLess.size() <= 0) continue;
            new StmtTraveler(){

                @Override
                public Stmt travel(Stmt stmt) {
                    Local local;
                    Stmt p = super.travel(stmt);
                    if (p.st == Stmt.ST.ASSIGN && p.getOp1().vt == Value.VT.LOCAL && p.getOp2().vt == Value.VT.NEW && !nAssign.containsKey(local = (Local)p.getOp1())) {
                        nAssign.put(local, (NewExpr)p.getOp2());
                        init.put(local, (AssignStmt)p);
                        changed[0] = true;
                    }
                    return p;
                }

                @Override
                public Value travel(Value op) {
                    Local local;
                    if (op.vt == Value.VT.LOCAL && oneOrLess.contains(local = (Local)op)) {
                        return (Value)nAssign.get(local);
                    }
                    return super.travel(op);
                }
            }.travel(method.stmts);
            for (Local local : oneOrLess) {
                nAssign.remove(local);
            }
            oneOrLess.clear();
        }
        HashSet<Local> replaced = new HashSet<Local>();
        Iterator<Stmt> it = method.stmts.iterator();
        while (it.hasNext()) {
            NewExpr newExpr;
            Stmt p = it.next();
            InvokeExpr ie = null;
            if (p.st == Stmt.ST.ASSIGN) {
                if (p.getOp2().vt == Value.VT.INVOKE_SPECIAL) {
                    ie = (InvokeExpr)p.getOp2();
                }
            } else if (p.st == Stmt.ST.VOID_INVOKE) {
                ie = (InvokeExpr)p.getOp();
            }
            if (ie == null || !"<init>".equals(ie.name) || !"V".equals(ie.ret)) continue;
            Value[] orgOps = ie.getOps();
            if (orgOps[0].vt == Value.VT.LOCAL) {
                Local objToInit = (Local)ie.getOps()[0];
                NewExpr newExpr2 = (NewExpr)nAssign.get(objToInit);
                if (newExpr2 == null) continue;
                if (!ie.owner.equals(newExpr2.type)) {
                    throw new RuntimeException("");
                }
                Value[] nOps = new Value[orgOps.length - 1];
                System.arraycopy(orgOps, 1, nOps, 0, nOps.length);
                InvokeExpr invokeNew = Exprs.nInvokeNew(nOps, ie.args, ie.owner);
                method.stmts.insertBefore(p, Stmts.nAssign(objToInit, invokeNew));
                it.remove();
                replaced.add(objToInit);
                continue;
            }
            if (orgOps[0].vt != Value.VT.NEW || (newExpr = (NewExpr)ie.getOps()[0]) == null) continue;
            Value[] nOps = new Value[orgOps.length - 1];
            System.arraycopy(orgOps, 1, nOps, 0, nOps.length);
            InvokeExpr invokeNew = Exprs.nInvokeNew(nOps, ie.args, ie.owner);
            method.stmts.insertBefore(p, Stmts.nVoidInvoke(invokeNew));
            it.remove();
        }
        nAssign.clear();
        for (Local x : replaced) {
            method.stmts.remove((Stmt)init.remove(x));
        }
    }
}

