/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.util.decompiler;

import jd.core.printer.Printer;

public abstract class ClassFileSourcePrinter
implements Printer {
    protected static final String TAB = "  ";
    protected static final String NEWLINE = "\n";
    protected int maxLineNumber = 0;
    protected int indentationCount;
    protected boolean display;

    protected abstract boolean getRealignmentLineNumber();

    protected abstract boolean isShowPrefixThis();

    protected abstract boolean isUnicodeEscape();

    protected abstract void append(char var1);

    protected abstract void append(String var1);

    @Override
    public void print(byte b) {
        this.append(String.valueOf(b));
    }

    @Override
    public void print(int i) {
        this.append(String.valueOf(i));
    }

    @Override
    public void print(char c) {
        if (this.display) {
            this.append(c);
        }
    }

    @Override
    public void print(String s) {
        if (this.display) {
            this.printEscape(s);
        }
    }

    @Override
    public void printNumeric(String s) {
        this.append(s);
    }

    @Override
    public void printString(String s, String scopeInternalName) {
        this.append(s);
    }

    @Override
    public void printKeyword(String s) {
        if (this.display) {
            this.append(s);
        }
    }

    @Override
    public void printJavaWord(String s) {
        this.append(s);
    }

    @Override
    public void printType(String internalName, String name, String scopeInternalName) {
        if (this.display) {
            this.printEscape(name);
        }
    }

    @Override
    public void printTypeDeclaration(String internalName, String name) {
        this.printEscape(name);
    }

    @Override
    public void printTypeImport(String internalName, String name) {
        this.printEscape(name);
    }

    @Override
    public void printField(String internalName, String name, String descriptor, String scopeInternalName) {
        this.printEscape(name);
    }

    @Override
    public void printFieldDeclaration(String internalName, String name, String descriptor) {
        this.printEscape(name);
    }

    @Override
    public void printStaticField(String internalName, String name, String descriptor, String scopeInternalName) {
        this.printEscape(name);
    }

    @Override
    public void printStaticFieldDeclaration(String internalName, String name, String descriptor) {
        this.printEscape(name);
    }

    @Override
    public void printConstructor(String internalName, String name, String descriptor, String scopeInternalName) {
        this.printEscape(name);
    }

    @Override
    public void printConstructorDeclaration(String internalName, String name, String descriptor) {
        this.printEscape(name);
    }

    @Override
    public void printStaticConstructorDeclaration(String internalName, String name) {
        this.append(name);
    }

    @Override
    public void printMethod(String internalName, String name, String descriptor, String scopeInternalName) {
        this.printEscape(name);
    }

    @Override
    public void printMethodDeclaration(String internalName, String name, String descriptor) {
        this.printEscape(name);
    }

    @Override
    public void printStaticMethod(String internalName, String name, String descriptor, String scopeInternalName) {
        this.printEscape(name);
    }

    @Override
    public void printStaticMethodDeclaration(String internalName, String name, String descriptor) {
        this.printEscape(name);
    }

    @Override
    public void start(int maxLineNumber, int majorVersion, int minorVersion) {
        this.indentationCount = 0;
        this.display = true;
        this.maxLineNumber = maxLineNumber;
    }

    @Override
    public void end() {
    }

    @Override
    public void indent() {
        ++this.indentationCount;
    }

    @Override
    public void desindent() {
        if (this.indentationCount > 0) {
            --this.indentationCount;
        }
    }

    @Override
    public void startOfLine(int lineNumber) {
        for (int i = 0; i < this.indentationCount; ++i) {
            this.append(TAB);
        }
    }

    @Override
    public void endOfLine() {
        this.append(NEWLINE);
    }

    @Override
    public void extraLine(int count) {
        if (this.getRealignmentLineNumber()) {
            while (count-- > 0) {
                this.append(NEWLINE);
            }
        }
    }

    @Override
    public void startOfComment() {
    }

    @Override
    public void endOfComment() {
    }

    @Override
    public void startOfJavadoc() {
    }

    @Override
    public void endOfJavadoc() {
    }

    @Override
    public void startOfXdoclet() {
    }

    @Override
    public void endOfXdoclet() {
    }

    @Override
    public void startOfError() {
    }

    @Override
    public void endOfError() {
    }

    @Override
    public void startOfImportStatements() {
    }

    @Override
    public void endOfImportStatements() {
    }

    @Override
    public void startOfTypeDeclaration(String internalPath) {
    }

    @Override
    public void endOfTypeDeclaration() {
    }

    @Override
    public void startOfAnnotationName() {
    }

    @Override
    public void endOfAnnotationName() {
    }

    @Override
    public void startOfOptionalPrefix() {
        if (!this.isShowPrefixThis()) {
            this.display = false;
        }
    }

    @Override
    public void endOfOptionalPrefix() {
        this.display = true;
    }

    @Override
    public void debugStartOfLayoutBlock() {
    }

    @Override
    public void debugEndOfLayoutBlock() {
    }

    @Override
    public void debugStartOfSeparatorLayoutBlock() {
    }

    @Override
    public void debugEndOfSeparatorLayoutBlock(int min, int value, int max) {
    }

    @Override
    public void debugStartOfStatementsBlockLayoutBlock() {
    }

    @Override
    public void debugEndOfStatementsBlockLayoutBlock(int min, int value, int max) {
    }

    @Override
    public void debugStartOfInstructionBlockLayoutBlock() {
    }

    @Override
    public void debugEndOfInstructionBlockLayoutBlock() {
    }

    @Override
    public void debugStartOfCommentDeprecatedLayoutBlock() {
    }

    @Override
    public void debugEndOfCommentDeprecatedLayoutBlock() {
    }

    @Override
    public void debugMarker(String marker) {
    }

    @Override
    public void debugStartOfCaseBlockLayoutBlock() {
    }

    @Override
    public void debugEndOfCaseBlockLayoutBlock() {
    }

    protected void printEscape(String s) {
        if (this.isUnicodeEscape()) {
            int length = s.length();
            for (int i = 0; i < length; ++i) {
                char c = s.charAt(i);
                if (c == '\t') {
                    this.append(c);
                    continue;
                }
                if (c < ' ') {
                    this.append("\\0");
                    this.append((char)(48 + (c >> 3)));
                    this.append((char)(48 + (c & 7)));
                    continue;
                }
                if (c > '\u007f') {
                    this.append("\\u");
                    int z = c >> 12;
                    this.append((char)(z <= 9 ? 48 + z : 55 + z));
                    z = c >> 8 & 0xF;
                    this.append((char)(z <= 9 ? 48 + z : 55 + z));
                    z = c >> 4 & 0xF;
                    this.append((char)(z <= 9 ? 48 + z : 55 + z));
                    z = c & 0xF;
                    this.append((char)(z <= 9 ? 48 + z : 55 + z));
                    continue;
                }
                this.append(c);
            }
        } else {
            this.append(s);
        }
    }
}

